import React, { Component } from 'react';
import Layout from '../components/Layout/Layout';
import Header from '../components/Header/Header';
import PageTitle from '../components/PageTitle/PageTitle';

class CookiePolicy extends Component {
  render() {
    return (
      <Layout type="static-page">
        <Layout.Header>
          <Header btnBack btnUser />
        </Layout.Header>
        <Layout.Container>
          <Layout.Inner>
            <PageTitle title="Cookie Policy" />
            <h4>O que são cookies?</h4>
            <p>
              Um cookie é um arquivo de texto armazenado no navegador da web de um usuário em qualquer dispositivo que eles usem para
              acessar um site que contém informações sobre a visita do usuário, como
              preferências.Quando o usuário retorna, o navegador fornece ao cookie o armazenado
              informações para o site.
            </p>
            <h4>Para quais cookies são usados?</h4>
            <p>
              Os cookies são usados para ajustar o conteúdo de um site para atender às preferências de um usuário e
              Otimize o site.Eles armazenam informações úteis que melhoram a experiência do usuário
              experiência de um site.Eles são mais comumente usados para:
            </p>
            <ul>
              <li>
            Armazenar informações de login para que um usuário não precise re-login em todas as visitas.
            </li>
            <li>
            Reconhecendo o tipo de dispositivo que um usuário está navegando e quaisquer preferências aplicadas
            Para otimizar o site especificamente para o dispositivo.
            </li>
            <li>
            Criando estatísticas que ajudam os proprietários do site a entender como seus usuários interagem
            com o site deles, o que lhes permite melhorar sua estrutura e conteúdo.
            </li>
            </ul>
            <h4> Que tipos de cookies são usados? </h4>
            <p>
            Existem dois tipos de cookies: cookies persistentes e biscoitos de sessão.Persistente
            Os cookies permanecem no seu disco rígido por um período de tempo especificado no arquivo do cookie
            parâmetros ou até remover manualmente.Quando você retornar a um site e exige você
            Para fazer o login novamente, apesar de anteriormente armazenar suas informações de login, geralmente é
            Porque o biscoito persistente expirou;Isso ajuda a aumentar a segurança enquanto
            mantendo acessibilidade.
            </p>
            <p>
            Os cookies da sessão, por outro lado, são usados temporariamente e expirarem quando o site
            ou navegador está fechado.Eles são usados para rastrear a atividade do usuário em um site durante um
            visita única.Quando um site exige que você verifique sua idade ou local uma vez a cada
            Visite antes de permitir que você visualize o conteúdo e sem exigir pessoal adicional
            Detalhes, esse é um cookie de sessão no trabalho.
            </p>
            <h4> Os cookies incluem dados pessoais? </h4>
            <p>
            Se houver necessidade de coleção de informações pessoais, como criar
            Contas, então os cookies podem armazenar informações pessoais.No entanto, é necessário pelos dados
            Lei de proteção que os usuários são informados da coleta de dados pessoais.Esses dados
            Também será criptografado para torná -lo inacessível para usuários não autorizados.
            </p>
            <h4>Gerenciando cookies</h4>
            <p>
              Por padrão, os navegadores estão configurados para aceitar cookies.No entanto, essas configurações podem ser
              alterado para bloquear os cookies completamente ou para informar o usuário sempre que forem usados.
              Informações detalhadas sobre cookies e as opções associadas a eles estão disponíveis
              nas configurações de cada navegador.
            </p>
          </Layout.Inner>
        </Layout.Container>
      </Layout>
    );
  }
}

export default CookiePolicy;
