import React from 'react';
import PropTypes from 'prop-types';
import { withRouter } from 'react-router-dom';
import { connect } from 'react-redux';
import './UserHome.scss';
import Button from '../Button/Button';
import Icon from '../Icon/Icon';
import CreateCanvasSection from '../CreateCanvasSection/CreateCanvasSection';
import PageTitle from '../PageTitle/PageTitle';
import Layout from '../Layout/Layout';
import MyCanvases from '../MyCanvases/MyCanvases';
import HowToCanvas from '../HowToCanvas/HowToCanvas';
import Section from '../Section/Section';
import SamplesList from '../SamplesList/SamplesList';

const LATEST_CANVASES_COUNT = 4;

const UserHome = ({ isEmpty }) => (
  <Layout.Container>
    <div className="user-home">
      <Layout.Inner>
        {isEmpty ? (
          <div className="user-home__latest">
            <PageTitle
              title="Bem-vindo! Vamos começar"
              subtitle="Escolha um tipo de tela que você deseja começar"
            />
            <CreateCanvasSection withDescription withCTA />
          </div>
        ) : (
          <div className="user-home__latest">
            <h3 className="user-home__latest-title">Meus últimos modelos</h3>
            <MyCanvases noWrap limit={LATEST_CANVASES_COUNT} />
            <div className="user-home__latest-more">
              <Button href="/dashboard" styleType="secondary" isFullWidth>
                <Icon name="dashboard" />
                Todos os meus modelos
              </Button>
            </div>
          </div>
        )}
      </Layout.Inner>
      <Section bg="lightgray" indent="medium">
        <Layout.Inner>
          <h2 className="text_align_center">Como trabalhar com o canvas</h2>
          <HowToCanvas />
        </Layout.Inner>
      </Section>
      <Layout.Inner>
        <h2 className="text_align_center">Verifique esses exemplos</h2>
        <SamplesList />
      </Layout.Inner>
    </div>
  </Layout.Container>
);

UserHome.propTypes = {
  isEmpty: PropTypes.bool.isRequired,
};

const mapStateToProps = (state, ownProps) => {
  const { canvasList } = state;
  const { isLoaded, canvases } = canvasList;
  const locState = ownProps.location.state || {};
  const isEmpty = locState.registered || (isLoaded && !canvases.length);

  return {
    isEmpty,
  };
};

export default withRouter(connect(mapStateToProps)(UserHome));
