/// <reference types="node" />
import type { MappingRange } from './types';
export declare function getFileContent(file: Buffer | string): string;
export declare function formatBytes(bytes: number, decimals?: number): string;
export declare function formatPercent(value: number, total: number, fractionDigits?: number): string;
export declare function getCommonPathPrefix(paths: string[]): string;
export declare function getFirstRegexMatch(regex: RegExp, string: string): string | null;
export declare function detectEOL(content: string): string;
export declare function getOccurrencesCount(subString: string, string: string): number;
export declare function isEOLAtPosition(string: string, [line, column]: [number, number]): boolean;
export declare function mergeRanges(ranges: MappingRange[]): MappingRange[];
