"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _component = _interopRequireDefault(require("cxs/component"));

var _Picture = _interopRequireDefault(require("./Picture"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var Wrapper = (0, _component["default"])("div")({
  width: "100%",
  height: "100%",
  position: "relative"
});
var PictureWrapper = (0, _component["default"])("div")({
  overflow: "hidden",
  top: 0,
  left: 0,
  right: 0,
  bottom: 0,
  position: "absolute"
});
var StyledPicture = (0, _component["default"])(_Picture["default"])(function (_ref) {
  var _ref$cover = _ref.cover,
      cover = _ref$cover === void 0 ? "both" : _ref$cover,
      _ref$center = _ref.center,
      center = _ref$center === void 0 ? true : _ref$center;
  return {
    position: "absolute",
    top: center ? "50%" : 0,
    left: center ? "50%" : 0,
    transform: center ? "translate(-50%, -50%)" : "none",
    width: cover === "width" ? "100%" : "auto",
    height: cover === "height" ? "100%" : "auto",
    minHeight: cover === "both" ? "100%" : "none",
    minWidth: cover === "both" ? "100%" : "none"
  };
});

var Fullsized = function Fullsized(_ref2) {
  var className = _ref2.className,
      wrapperClassName = _ref2.wrapperClassName,
      children = _ref2.children,
      rest = _objectWithoutPropertiesLoose(_ref2, ["className", "wrapperClassName", "children"]);

  return _react["default"].createElement(Wrapper, {
    className: wrapperClassName
  }, _react["default"].createElement(PictureWrapper, null, _react["default"].createElement(StyledPicture, _extends({
    className: className
  }, rest)), children));
};

var _default = Fullsized;
exports["default"] = _default;