'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderStatic = renderStatic;
exports.renderStaticOptimized = renderStaticOptimized;

var _index = require('./index.js');

/**** serverside stuff ****/

// the api's copied from aphrodite, with 1 key difference
// we include *all* the css generated by the app
// to optimize to only include generated styles on the pages
// use renderStaticOptimized
function renderStatic(fn) {
  var html = fn();
  if (html === undefined) {
    throw new Error('did you forget to return from renderToString?');
  }

  var rules = _index.styleSheet.rules(),
      css = rules.map(function (r) {
    return r.cssText;
  }).join('');
  return { html: html, ids: Object.keys(_index.styleSheet.inserted), css: css, rules: rules };
}

function renderStaticOptimized(fn) {
  // parse out ids from html
  // reconstruct css/rules/cache to pass
  var html = fn();
  if (html === undefined) {
    throw new Error('did you forget to return from renderToString?');
  }
  var o = { html: html, ids: [], css: '', rules: [] };
  var regex = /css\-([a-zA-Z0-9\-_]+)/gm;
  var match = void 0,
      ids = {};
  while ((match = regex.exec(html)) !== null) {
    if (!ids[match[1] + '']) {
      ids[match[1] + ''] = true;
    }
  }

  o.rules = _index.styleSheet.rules().filter(function (x) {
    var regex = /css\-([a-zA-Z0-9\-_]+)/gm;
    var match = regex.exec(x.cssText);
    if (match && ids[match[1] + '']) {
      return true;
    }
    if (!match) {
      return true;
    }
    return false;
  });
  o.ids = Object.keys(_index.styleSheet.inserted).filter(function (id) {
    return !!ids[id + ''] || _index.styleSheet.registered[id].type === 'raw' || _index.styleSheet.registered[id].type === 'keyframes' || _index.styleSheet.registered[id].type === 'font-face';
  });
  o.css = o.rules.map(function (x) {
    return x.cssText;
  }).join('');

  return o;
}