'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = processStyleWithPlugins;

var _arrayReduce = require('./arrayReduce');

var _arrayReduce2 = _interopRequireDefault(_arrayReduce);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function processStyleWithPlugins(renderer, style, type) {
  var props = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

  if (renderer.plugins.length > 0) {
    return (0, _arrayReduce2.default)(renderer.plugins, function (processedStyle, plugin) {
      processedStyle = plugin(processedStyle, type, renderer, props);
      return processedStyle;
    }, style);
  }

  return style;
}