'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createStyleNode;
function getDocumentHead() {
  return document.head ? document.head : {};
}

function createStyleNode(type) {
  var media = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var anchorNode = arguments[2];

  var head = getDocumentHead();
  var node = document.createElement('style');
  node.setAttribute('data-fela-type', type);
  node.type = 'text/css';

  if (media.length > 0) {
    node.media = media;
    head.appendChild(node);
  } else {
    head.insertBefore(node, anchorNode);
  }

  return node;
}