'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderToString;

var _felaUtils = require('fela-utils');

function renderToString(renderer) {
  var basicCSS = renderer.fontFaces + renderer.statics + renderer.keyframes + renderer.rules;

  return (0, _felaUtils.objectReduce)(renderer.mediaRules, function (css, rules, query) {
    return css + (0, _felaUtils.cssifyMediaQueryRules)(query, rules);
  }, basicCSS);
}