'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _felaUtils = require('fela-utils');

exports.default = {
  create: function create(styleSheet) {
    return (0, _felaUtils.objectReduce)(styleSheet, function (ruleSheet, rule, ruleName) {
      if (typeof rule === 'function') {
        ruleSheet[ruleName] = rule;
      } else {
        ruleSheet[ruleName] = function () {
          return rule;
        };
        ruleSheet[ruleName].ruleName = ruleName;
      }

      return ruleSheet;
    }, {});
  }
};