import { cssifyMediaQueryRules, objectReduce } from 'fela-utils';

export default function renderToString(renderer) {
  var basicCSS = renderer.fontFaces + renderer.statics + renderer.keyframes + renderer.rules;

  return objectReduce(renderer.mediaRules, function (css, rules, query) {
    return css + cssifyMediaQueryRules(query, rules);
  }, basicCSS);
}