import { objectReduce } from 'fela-utils';

export default {
  create: function create(styleSheet) {
    return objectReduce(styleSheet, function (ruleSheet, rule, ruleName) {
      if (typeof rule === 'function') {
        ruleSheet[ruleName] = rule;
      } else {
        ruleSheet[ruleName] = function () {
          return rule;
        };
        ruleSheet[ruleName].ruleName = ruleName;
      }

      return ruleSheet;
    }, {});
  }
};