'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = render;

var _felaTools = require('fela-tools');

var _DOMInterface = require('./DOMInterface');

var _DOMInterface2 = _interopRequireDefault(_DOMInterface);

var _initStyleNodes = require('./initStyleNodes');

var _initStyleNodes2 = _interopRequireDefault(_initStyleNodes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var warnDeprecated = false;
function render(renderer, mountNode) {
  // legacy support for single stylesheets
  // will be removed soon
  if (mountNode) {
    if (!warnDeprecated) {
      // TODO: warn
      warnDeprecated = true;
    }

    (0, _felaTools.renderToElement)(renderer, mountNode);
  } else {
    (0, _initStyleNodes2.default)(renderer);
    var updateInterface = (0, _DOMInterface2.default)(renderer);
    renderer.subscribe(updateInterface);
  }
}