'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = initStyleNodes;

var _felaUtils = require('fela-utils');

var sheetMap = {
  fontFaces: _felaUtils.FONT_TYPE,
  statics: _felaUtils.STATIC_TYPE,
  keyframes: _felaUtils.KEYFRAME_TYPE,
  rules: _felaUtils.RULE_TYPE
};


function initNode(styleNodes, baseNode, css, type) {
  var media = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';

  var node = (0, _felaUtils.getStyleNode)(styleNodes, baseNode, type, media);
  // in case that there is a node coming from server already
  // but rules are not matchnig
  if (node.textContent !== css) {
    node.textContent = css;
  }
}

function initStyleNodes(renderer) {
  renderer.styleNodes = (0, _felaUtils.reflushStyleNodes)();
  var baseNode = renderer.styleNodes[_felaUtils.RULE_TYPE];

  for (var style in sheetMap) {
    if (renderer[style].length > 0) {
      initNode(renderer.styleNodes, baseNode, renderer[style], sheetMap[style]);
    }
  }

  for (var media in renderer.mediaRules) {
    var mediaCSS = renderer.mediaRules[media];

    if (mediaCSS.length > 0) {
      initNode(renderer.styleNodes, baseNode, mediaCSS, _felaUtils.RULE_TYPE, media);
    }
  }
}