var _sheetMap;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import { RULE_TYPE, KEYFRAME_TYPE, FONT_TYPE, STATIC_TYPE, CLEAR_TYPE, reflushStyleNodes, getStyleNode } from 'fela-utils';

var sheetMap = (_sheetMap = {}, _defineProperty(_sheetMap, FONT_TYPE, 'fontFaces'), _defineProperty(_sheetMap, STATIC_TYPE, 'statics'), _defineProperty(_sheetMap, KEYFRAME_TYPE, 'keyframes'), _sheetMap);

export default function createDOMInterface(renderer) {
  renderer.styleNodes = reflushStyleNodes();
  var baseNode = renderer.styleNodes[RULE_TYPE];

  return function changeSubscription(change) {
    if (change.type === CLEAR_TYPE) {
      for (var node in renderer.styleNodes) {
        renderer.styleNodes[node].textContent = '';
      }

      return;
    }

    var styleNode = getStyleNode(renderer.styleNodes, baseNode, change.type, change.media);

    if (change.type === RULE_TYPE) {
      // only use insertRule in production as browser devtools might have
      // weird behavior if used together with insertRule at runtime
      if (process.env.NODE_ENV !== 'production') {
        if (change.media) {
          styleNode.textContent = renderer.mediaRules[change.media];
        } else {
          styleNode.textContent = renderer.rules;
        }
      } else {
        try {
          styleNode.sheet.insertRule(change.selector + '{' + change.declaration + '}', styleNode.sheet.cssRules.length);
        } catch (error) {
          // TODO: maybe warn in dev?
        }
      }
    } else {
      styleNode.textContent = renderer[sheetMap[change.type]];
    }
  };
}