"use strict";

exports.__esModule = true;
exports.omit = omit;
exports.keys = keys;
exports.forEach = forEach;
exports.map = map;
function omit(obj, keys) {
  var target = {};
  var i = void 0;
  for (i in obj) {
    if (keys.indexOf(i) !== -1) continue;
    if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
    target[i] = obj[i];
  }
  return target;
}

function keys(obj) {
  var k = void 0;
  var out = [];
  for (k in obj) {
    out.push(k);
  }
  return out;
}

function forEach(arr, fn) {
  var i = 0;
  var len = arr.length;

  for (; i < len; i++) {
    fn(arr[i], i, arr);
  }
}

function map(arr, fn) {
  if (arr == null) {
    return [];
  }

  var i = 0;
  var len = arr.length;
  var out = new Array(len);

  for (; i < len; i++) {
    out[i] = fn(arr[i], i, arr);
  }

  return out;
}