'use strict';

exports.__esModule = true;
exports.parseCSS = parseCSS;

var _parse = require('styled-components/lib/vendor/postcss-safe-parser/parse');

var _parse2 = _interopRequireDefault(_parse);

var _postcssNested = require('styled-components/lib/vendor/postcss-nested');

var _postcssNested2 = _interopRequireDefault(_postcssNested);

var _stringify = require('styled-components/lib/vendor/postcss/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _autoprefix = require('styled-components/lib/utils/autoprefix');

var _autoprefix2 = _interopRequireDefault(_autoprefix);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function parseCSS(css) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
    nested: true,
    inlineMode: true,
    matches: 0,
    name: 'name',
    hash: 'hash',
    canCompose: false
  };

  // todo - handle errors
  var root = (0, _parse2.default)(css);
  if (options.nested !== false) (0, _postcssNested2.default)(root);

  var vars = 0;
  var composes = 0;
  var hasCssFunction = false;
  root.walkDecls(function (decl) {
    if (decl.prop === 'name') decl.remove();
    if (decl.value.match(/attr/)) {
      hasCssFunction = true;
    }
    if (options.canCompose) {
      if (decl.prop === 'composes') {
        if (decl.parent.selector !== '.' + options.name + '-' + options.hash) {
          throw new Error('composes cannot be on nested selectors');
        }
        if (!/xxx(\d+)xxx/gm.exec(decl.value)) {
          throw new Error('composes must be a interpolation');
        }
        if (decl.parent.nodes[0] !== decl) {
          throw new Error('composes must be the first rule');
        }
        var composeMatches = decl.value.match(/xxx(\d+)xxx/gm);
        var numOfComposes = !composeMatches ? 0 : composeMatches.length;
        composes += numOfComposes;
        vars += numOfComposes;
        decl.remove();
        return;
      }
    }
    if (!options.inlineMode) {
      var match = /xxx(\d+)xxx/gm.exec(decl.value);
      if (match) {
        vars++;
      }
    }
  });
  if (!options.inlineMode && vars === options.matches && !hasCssFunction) {
    root.walkDecls(function (decl) {
      decl.value = decl.value.replace(/xxx(\d+)xxx/gm, function (match, p1) {
        return 'var(--' + options.name + '-' + options.hash + '-' + (p1 - composes) + ')';
      });
    });
  }

  root.walkRules(function (rule) {
    if (rule.nodes.length === 0) {
      rule.remove();
    }
  });

  (0, _autoprefix2.default)(root);
  return {
    rules: stringifyCSSRoot(root),
    hasOtherMatch: vars !== options.matches,
    hasVar: !!vars && vars !== composes || !!(options.inlineMode && options.matches),
    composes: composes,
    hasCssFunction: hasCssFunction
  };
}

function stringifyCSSRoot(root) {
  return root.nodes.map(function (node, i) {
    var str = '';
    (0, _stringify2.default)(node, function (x) {
      str += x;
    });
    return str;
  });
}