'use strict';

var _babel = require('./babel');

var _babelUtils = require('./babel-utils');

var _inline = require('./inline');

var _utils = require('./utils');

module.exports = function macro(_ref) {
  var references = _ref.references,
      state = _ref.state,
      t = _ref.babel.types;

  if (!state.inline) state.inline = true;
  (0, _utils.forEach)((0, _utils.keys)(references), function (referenceKey) {
    if (referenceKey === 'injectGlobal') {
      references.injectGlobal.forEach(function (injectGlobalReference) {
        var path = injectGlobalReference.parentPath;
        if (t.isIdentifier(path.node.tag) && t.isTemplateLiteral(path.node.quasi)) {
          (0, _babel.replaceGlobalWithCallExpression)((0, _babelUtils.buildMacroRuntimeNode)(injectGlobalReference, state, 'injectGlobal', t), _inline.injectGlobal, path, state, t);
        }
      });
    } else if (referenceKey === 'fontFace') {
      references.fontFace.forEach(function (fontFaceReference) {
        var path = fontFaceReference.parentPath;
        if (t.isIdentifier(path.node.tag) && t.isTemplateLiteral(path.node.quasi)) {
          (0, _babel.replaceGlobalWithCallExpression)((0, _babelUtils.buildMacroRuntimeNode)(fontFaceReference, state, 'fontFace', t), _inline.fontFace, path, state, t);
        }
      });
    } else if (referenceKey === 'css') {
      references.css.forEach(function (cssReference) {
        var path = cssReference.parentPath;
        var runtimeNode = (0, _babelUtils.buildMacroRuntimeNode)(cssReference, state, 'css', t);
        if (t.isIdentifier(path.node.tag) && t.isTemplateLiteral(path.node.quasi)) {
          (0, _babel.replaceCssWithCallExpression)(path, runtimeNode, state, t);
        } else {
          cssReference.replaceWith(runtimeNode);
        }
      });
    } else if (referenceKey === 'keyframes') {
      references.keyframes.forEach(function (keyframesReference) {
        var path = keyframesReference.parentPath;
        if (t.isIdentifier(path.node.tag) && t.isTemplateLiteral(path.node.quasi)) {
          (0, _babel.replaceKeyframesWithCallExpression)(path, (0, _babelUtils.buildMacroRuntimeNode)(keyframesReference, state, 'keyframes', t), state, t);
        }
      });
    } else {
      references[referenceKey].forEach(function (reference) {
        reference.replaceWith((0, _babelUtils.buildMacroRuntimeNode)(reference, state, referenceKey, t));
      });
    }
  });
  (0, _babelUtils.addRuntimeImports)(state, t);
};