'use strict';

exports.__esModule = true;
exports.inline = inline;
exports.keyframes = keyframes;
exports.fontFace = fontFace;
exports.injectGlobal = injectGlobal;

var _parser = require('./parser');

var _hash = require('./hash');

function extractNameFromProperty(str) {
  var regex = /name\s*:\s*([A-Za-z0-9\-_]+)\s*/gm;
  var match = regex.exec(str);
  if (match) {
    return match[1];
  }
}

function getName(extracted, identifierName, prefix) {
  var parts = [];
  parts.push(prefix);
  if (extracted) {
    parts.push(extracted);
  } else if (identifierName) {
    parts.push(identifierName);
  }
  return parts.join('-');
}

function createSrc(strs, name, hash) {
  var matches = 0;
  var src = strs.reduce(function (arr, str, i) {
    arr.push(str);
    if (i !== strs.length - 1) {
      matches++;
      arr.push('xxx' + i + 'xxx');
    }
    return arr;
  }, []).join('').trim();
  return { src: src, matches: matches };
}

function inline(quasi, identifierName, prefix, inlineMode) {
  var strs = quasi.quasis.map(function (x) {
    return x.value.cooked;
  });
  var hash = (0, _hash.hashArray)([].concat(strs) // todo - add current filename?
  );var name = getName(extractNameFromProperty(strs.join('xxx')), identifierName, prefix);

  var _createSrc = createSrc(strs, name, hash),
      src = _createSrc.src,
      matches = _createSrc.matches;

  var _parseCSS = (0, _parser.parseCSS)('.' + name + '-' + hash + ' { ' + src + ' }', {
    inlineMode: inlineMode,
    matches: matches,
    name: name,
    hash: hash,
    canCompose: true
  }),
      rules = _parseCSS.rules,
      hasVar = _parseCSS.hasVar,
      hasOtherMatch = _parseCSS.hasOtherMatch,
      composes = _parseCSS.composes,
      hasCssFunction = _parseCSS.hasCssFunction;

  return { hash: hash, name: name, rules: rules, hasVar: hasVar, hasOtherMatch: hasOtherMatch, composes: composes, hasCssFunction: hasCssFunction };
}

function keyframes(quasi, identifierName, prefix) {
  var strs = quasi.quasis.map(function (x) {
    return x.value.cooked;
  });
  var hash = (0, _hash.hashArray)([].concat(strs));
  var name = getName(extractNameFromProperty(strs.join('xxx')), identifierName, prefix);

  var _createSrc2 = createSrc(strs, name, hash),
      src = _createSrc2.src,
      matches = _createSrc2.matches;

  var _parseCSS2 = (0, _parser.parseCSS)('{ ' + src + ' }', {
    nested: false,
    inlineMode: true,
    matches: matches,
    name: name,
    hash: hash
  }),
      rules = _parseCSS2.rules,
      hasVar = _parseCSS2.hasVar,
      hasOtherMatch = _parseCSS2.hasOtherMatch;

  return { hash: hash, name: name, rules: rules, hasInterpolation: hasVar || hasOtherMatch };
}

function fontFace(quasi) {
  var strs = quasi.quasis.map(function (x) {
    return x.value.cooked;
  });

  var _createSrc3 = createSrc(strs, 'name', 'hash'),
      src = _createSrc3.src,
      matches = _createSrc3.matches;

  var _parseCSS3 = (0, _parser.parseCSS)('@font-face {' + src + '}', {
    matches: matches,
    inlineMode: true,
    name: 'name',
    hash: 'hash'
  }),
      rules = _parseCSS3.rules,
      hasVar = _parseCSS3.hasVar,
      hasOtherMatch = _parseCSS3.hasOtherMatch;

  return { rules: rules, hasInterpolation: hasVar || hasOtherMatch };
}

function injectGlobal(quasi) {
  var strs = quasi.quasis.map(function (x) {
    return x.value.cooked;
  });

  var _createSrc4 = createSrc(strs, 'name', 'hash'),
      src = _createSrc4.src,
      matches = _createSrc4.matches;

  var _parseCSS4 = (0, _parser.parseCSS)(src, {
    matches: matches,
    inlineMode: true,
    name: 'name',
    hash: 'hash'
  }),
      rules = _parseCSS4.rules,
      hasVar = _parseCSS4.hasVar,
      hasOtherMatch = _parseCSS4.hasOtherMatch;

  return { rules: rules, hasInterpolation: hasVar || hasOtherMatch };
}