'use strict';

exports.__esModule = true;
exports.buildStyledCallExpression = buildStyledCallExpression;
exports.buildStyledObjectCallExpression = buildStyledObjectCallExpression;
exports.replaceGlobalWithCallExpression = replaceGlobalWithCallExpression;
exports.replaceCssWithCallExpression = replaceCssWithCallExpression;
exports.replaceKeyframesWithCallExpression = replaceKeyframesWithCallExpression;

exports.default = function (babel) {
  var t = babel.types;


  return {
    name: 'emotion', // not required
    inherits: require('babel-plugin-syntax-jsx'),
    visitor: {
      Program: {
        enter: function enter(path, state) {
          state.inline = path.hub.file.opts.filename === 'unknown' || state.opts.inline;
          state.staticRules = [];
          state.insertStaticRules = function (staticRules) {
            var _state$staticRules;

            (_state$staticRules = state.staticRules).push.apply(_state$staticRules, staticRules);
          };
        },
        exit: function exit(path, state) {
          if (state.staticRules.length !== 0) {
            var toWrite = state.staticRules.join('\n').trim();
            var filenameArr = path.hub.file.opts.filename.split('.');
            filenameArr.pop();
            filenameArr.push('emotion', 'css');
            var cssFilename = filenameArr.join('.');
            var exists = _fs2.default.existsSync(cssFilename);
            path.node.body.unshift(t.importDeclaration([], t.stringLiteral('./' + (0, _path.basename)(cssFilename))));
            if (exists ? _fs2.default.readFileSync(cssFilename, 'utf8') !== toWrite : true) {
              if (!exists) {
                (0, _touch.touchSync)(cssFilename);
              }
              _fs2.default.writeFileSync(cssFilename, toWrite);
            }
          }
        }
      },
      JSXOpeningElement: function JSXOpeningElement(path, state) {
        (0, _cssProp2.default)(path, t);
      },
      CallExpression: function CallExpression(path) {
        if (path[visited]) {
          return;
        }
        if (t.isCallExpression(path.node.callee) && path.node.callee.callee.name === 'styled' || t.isMemberExpression(path.node.callee) && t.isIdentifier(path.node.callee.object) && path.node.callee.object.name === 'styled') {
          var identifier = t.isCallExpression(path.node.callee) ? path.node.callee.callee : path.node.callee.object;
          path.replaceWith(buildStyledObjectCallExpression(path, identifier, t));
        }

        if (t.isCallExpression(path.node) && path.node.callee.name === 'css') {
          var prefixedAst = prefixAst(path.node.arguments, t);
          path.replaceWith(t.callExpression(t.identifier('css'), prefixedAst));
        }
        path[visited] = true;
      },
      TaggedTemplateExpression: function TaggedTemplateExpression(path, state) {
        // in:
        // styled.h1`color:${color};`
        //
        // out:
        // styled('h1', "css-r1aqtk", [colorVar, heightVar], function inlineCss(x0, x1) {
        //   return [`.css-r1aqtk {
        //     margin: 12px;
        //     color: ${x0};
        //     height: ${x1}; }`];
        // });
        if (
        // styled.h1`color:${color};`
        t.isMemberExpression(path.node.tag) && path.node.tag.object.name === 'styled') {
          path.replaceWith(buildStyledCallExpression(path.node.tag.object, t.stringLiteral(path.node.tag.property.name), path, state, t));
        } else if (
        // styled('h1')`color:${color};`
        t.isCallExpression(path.node.tag) && path.node.tag.callee.name === 'styled') {
          path.replaceWith(buildStyledCallExpression(path.node.tag.callee, path.node.tag.arguments[0], path, state, t));
        } else if (t.isIdentifier(path.node.tag)) {
          if (path.node.tag.name === 'css') {
            replaceCssWithCallExpression(path, t.identifier('css'), state, t);
          } else if (path.node.tag.name === 'keyframes') {
            replaceKeyframesWithCallExpression(path, t.identifier('keyframes'), state, t);
          } else if (path.node.tag.name === 'fontFace') {
            replaceGlobalWithCallExpression(t.identifier('fontFace'), _inline3.fontFace, path, state, t);
          } else if (path.node.tag.name === 'injectGlobal') {
            replaceGlobalWithCallExpression(t.identifier('injectGlobal'), _inline3.injectGlobal, path, state, t);
          }
        }
      }
    }
  };
};

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _touch = require('touch');

var _postcssJs = require('postcss-js');

var _postcssJs2 = _interopRequireDefault(_postcssJs);

var _autoprefixer = require('autoprefixer');

var _autoprefixer2 = _interopRequireDefault(_autoprefixer);

var _inline3 = require('./inline');

var _babelUtils = require('./babel-utils');

var _cssProp = require('./css-prop');

var _cssProp2 = _interopRequireDefault(_cssProp);

var _attrs = require('./attrs');

var _attrs2 = _interopRequireDefault(_attrs);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function joinExpressionsWithSpaces(expressions, t) {
  var quasis = [t.templateElement({ cooked: '', raw: '' }, true)];
  expressions.forEach(function (x, i) {
    if (i === expressions.length - 1) {
      return quasis.push(t.templateElement({ cooked: '', raw: '' }, true));
    }
    quasis.push(t.templateElement({ cooked: ' ', raw: ' ' }, true));
  });
  return t.templateLiteral(quasis, expressions);
}

function parseDynamicValues(rules, t, options) {
  if (options.composes === undefined) options.composes = 0;
  return rules.map(function (rule) {
    var re = /xxx(\d+)xxx|attr\(([^,\s)]+)(?:\s*([^,)]*)?)(?:,\s*(\S+))?\)/gm;
    var VAR = 'VAR';
    var ATTR = 'ATTR';
    var match = void 0;
    var matches = [];
    while ((match = re.exec(rule)) !== null) {
      if (match[1]) {
        matches.push({
          value: match[0],
          p1: match[1],
          index: match.index,
          type: VAR
        });
      } else {
        matches.push({
          value: match[0],
          propName: match[2],
          valueType: match[3],
          defaultValue: match[4],
          index: match.index,
          type: ATTR
        });
      }
    }

    var cursor = 0;

    var _matches$reduce = matches.reduce(function (accum, match, i) {
      var quasis = accum[0],
          expressions = accum[1];

      var preMatch = rule.substring(cursor, match.index);
      cursor = cursor + preMatch.length + match.value.length;
      if (preMatch) {
        quasis.push(t.templateElement({ raw: preMatch, cooked: preMatch }));
      }
      if (match.type === VAR) {
        if (options.inputExpressions) {
          expressions.push(options.inputExpressions[match.p1 - options.composes]);
        } else {
          expressions.push(t.identifier('x' + (match.p1 - options.composes)));
        }
      }
      if (match.type === ATTR) {
        var expr = (0, _attrs2.default)(match, options.vars, options.composes, t);
        options.vars.push(expr);
        expressions.push(t.identifier('x' + (options.vars.length - 1)));
      }

      if (i === matches.length - 1 && cursor <= rule.length) {
        var postMatch = rule.substring(cursor);

        quasis.push(t.templateElement({
          raw: postMatch,
          cooked: postMatch
        }, true));
      }
      return accum;
    }, [[], []]),
        quasis = _matches$reduce[0],
        expressions = _matches$reduce[1];

    if (!matches.length) {
      return t.templateLiteral([t.templateElement({ raw: rule, cooked: rule }, true)], []);
    }

    return t.templateLiteral(quasis, expressions);
  });
}

function buildStyledCallExpression(identifier, tag, path, state, t) {
  var identifierName = (0, _babelUtils.getIdentifierName)(path, t);

  var _inline = (0, _inline3.inline)(path.node.quasi, identifierName, 'css', state.inline

  // hash will be '0' when no styles are passed so we can just return the original tag
  ),
      hash = _inline.hash,
      rules = _inline.rules,
      name = _inline.name,
      hasOtherMatch = _inline.hasOtherMatch,
      composes = _inline.composes,
      hasCssFunction = _inline.hasCssFunction;

  if (hash === '0') {
    return tag;
  }
  var inputClasses = [t.stringLiteral(name + '-' + hash)];
  for (var i = 0; i < composes; i++) {
    inputClasses.push(path.node.quasi.expressions.shift());
  }

  var vars = path.node.quasi.expressions;

  var dynamicValues = parseDynamicValues(rules, t, { composes: composes, vars: vars });
  var args = [tag, t.arrayExpression(inputClasses), t.arrayExpression(vars)];
  if (!hasOtherMatch && !state.inline && !hasCssFunction) {
    state.insertStaticRules(rules);
  } else if (rules.length !== 0) {
    var inlineContentExpr = t.functionExpression(t.identifier('createEmotionStyledRules'), vars.map(function (x, i) {
      return t.identifier('x' + i);
    }), t.blockStatement([t.returnStatement(t.arrayExpression(dynamicValues))]));
    args.push(inlineContentExpr);
  }

  return t.callExpression(identifier, args);
}

function buildStyledObjectCallExpression(path, identifier, t) {
  var tag = t.isCallExpression(path.node.callee) ? path.node.callee.arguments[0] : t.stringLiteral(path.node.callee.property.name);
  return t.callExpression(identifier, [tag, t.arrayExpression(prefixAst(path.node.arguments, t)), t.arrayExpression()]);
}

function replaceGlobalWithCallExpression(identifier, processQuasi, path, state, t) {
  var _processQuasi = processQuasi(path.node.quasi),
      rules = _processQuasi.rules,
      hasInterpolation = _processQuasi.hasInterpolation;

  if (!hasInterpolation && !state.inline) {
    state.insertStaticRules(rules);
    if (t.isExpressionStatement(path.parent)) {
      path.parentPath.remove();
    } else {
      path.replaceWith(t.identifier('undefined'));
    }
  } else {
    path.replaceWith(t.callExpression(identifier, [t.arrayExpression(parseDynamicValues(rules, t, {
      inputExpressions: path.node.quasi.expressions
    }))]));
  }
}

function prefixAst(args, t) {
  var prefixer = _postcssJs2.default.sync([_autoprefixer2.default]);

  function isLiteral(value) {
    return t.isStringLiteral(value) || t.isNumericLiteral(value) || t.isBooleanLiteral(value);
  }
  if (Array.isArray(args)) {
    return args.map(function (element) {
      return prefixAst(element, t);
    });
  }

  if (t.isObjectExpression(args)) {
    var properties = [];
    args.properties.forEach(function (property) {
      // nested objects
      if (t.isObjectExpression(property.value)) {
        var key = t.isStringLiteral(property.key) ? t.stringLiteral(property.key.value) : t.identifier(property.key.name);
        return properties.push(t.objectProperty(key, prefixAst(property.value, t))

        // literal value or array of literal values
        );
      } else if (isLiteral(property.value) || t.isArrayExpression(property.value) && property.value.elements.every(isLiteral)) {
        var _style;

        // handle array values: { display: ['flex', 'block'] }
        var propertyValue = t.isArrayExpression(property.value) ? property.value.elements.map(function (element) {
          return element.value;
        }) : property.value.value;

        var style = (_style = {}, _style[property.key.name] = propertyValue, _style);
        var prefixedStyle = prefixer(style);

        for (var k in prefixedStyle) {
          var _key = t.isStringLiteral(property.key) ? t.stringLiteral(k) : t.identifier(k);
          var val = prefixedStyle[k];
          var value = void 0;

          if (typeof val === 'number') {
            value = t.numericLiteral(val);
          } else if (typeof val === 'string') {
            value = t.stringLiteral(val);
          } else if (Array.isArray(val)) {
            value = t.arrayExpression(val.map(function (i) {
              return t.stringLiteral(i);
            }));
          }

          properties.push(t.objectProperty(_key, value));
        }

        // expressions
      } else {
        properties.push(property);
      }
    });

    return t.objectExpression(properties);
  }

  if (t.isArrayExpression(args)) {
    return t.arrayExpression(prefixAst(args.elements, t));
  }

  return args;
}

function replaceCssWithCallExpression(path, identifier, state, t) {
  try {
    var _inline2 = (0, _inline3.inline)(path.node.quasi, (0, _babelUtils.getIdentifierName)(path, t), 'css', state.inline),
        hash = _inline2.hash,
        name = _inline2.name,
        rules = _inline2.rules,
        hasVar = _inline2.hasVar,
        composes = _inline2.composes,
        hasOtherMatch = _inline2.hasOtherMatch;

    var inputClasses = [t.stringLiteral(name + '-' + hash)];
    for (var i = 0; i < composes; i++) {
      inputClasses.push(path.node.quasi.expressions.shift());
    }
    var args = [t.arrayExpression(inputClasses), t.arrayExpression(path.node.quasi.expressions)];
    if (!hasOtherMatch && !state.inline) {
      state.insertStaticRules(rules);
      if (!hasVar) {
        return path.replaceWith(joinExpressionsWithSpaces(inputClasses, t));
      }
    } else if (rules.length !== 0) {
      var expressions = path.node.quasi.expressions.map(function (x, i) {
        return t.identifier('x' + i);
      });
      var inlineContentExpr = t.functionExpression(t.identifier('createEmotionRules'), expressions, t.blockStatement([t.returnStatement(t.arrayExpression(parseDynamicValues(rules, t, {
        inputExpressions: expressions,
        composes: composes
      })))]));
      args.push(inlineContentExpr);
    }
    path.replaceWith(t.callExpression(identifier, args));
  } catch (e) {
    throw path.buildCodeFrameError(e);
  }
}

function replaceKeyframesWithCallExpression(path, identifier, state, t) {
  var _keyframes = (0, _inline3.keyframes)(path.node.quasi, (0, _babelUtils.getIdentifierName)(path, t), 'animation'),
      hash = _keyframes.hash,
      name = _keyframes.name,
      rules = _keyframes.rules,
      hasInterpolation = _keyframes.hasInterpolation;

  var animationName = name + '-' + hash;
  if (!hasInterpolation && !state.inline) {
    state.insertStaticRules(['@keyframes ' + animationName + ' ' + rules.join('')]);
    path.replaceWith(t.stringLiteral(animationName));
  } else {
    path.replaceWith(t.callExpression(identifier, [t.stringLiteral(animationName), t.arrayExpression(parseDynamicValues(rules, t, {
      inputExpressions: path.node.quasi.expressions
    }))]));
  }
}

var visited = Symbol('visited');