// Original file: deps/protoc-gen-validate/validate/validate.proto


/**
 * DoubleRules describes the constraints applied to `double` values
 */
export interface DoubleRules {
  /**
   * Const specifies that this field must be exactly the specified value
   */
  'const'?: (number | string);
  /**
   * Lt specifies that this field must be less than the specified value,
   * exclusive
   */
  'lt'?: (number | string);
  /**
   * Lte specifies that this field must be less than or equal to the
   * specified value, inclusive
   */
  'lte'?: (number | string);
  /**
   * Gt specifies that this field must be greater than the specified value,
   * exclusive. If the value of Gt is larger than a specified Lt or Lte, the
   * range is reversed.
   */
  'gt'?: (number | string);
  /**
   * Gte specifies that this field must be greater than or equal to the
   * specified value, inclusive. If the value of Gte is larger than a
   * specified Lt or Lte, the range is reversed.
   */
  'gte'?: (number | string);
  /**
   * In specifies that this field must be equal to one of the specified
   * values
   */
  'in'?: (number | string)[];
  /**
   * NotIn specifies that this field cannot be equal to one of the specified
   * values
   */
  'not_in'?: (number | string)[];
}

/**
 * DoubleRules describes the constraints applied to `double` values
 */
export interface DoubleRules__Output {
  /**
   * Const specifies that this field must be exactly the specified value
   */
  'const': (number | string);
  /**
   * Lt specifies that this field must be less than the specified value,
   * exclusive
   */
  'lt': (number | string);
  /**
   * Lte specifies that this field must be less than or equal to the
   * specified value, inclusive
   */
  'lte': (number | string);
  /**
   * Gt specifies that this field must be greater than the specified value,
   * exclusive. If the value of Gt is larger than a specified Lt or Lte, the
   * range is reversed.
   */
  'gt': (number | string);
  /**
   * Gte specifies that this field must be greater than or equal to the
   * specified value, inclusive. If the value of Gte is larger than a
   * specified Lt or Lte, the range is reversed.
   */
  'gte': (number | string);
  /**
   * In specifies that this field must be equal to one of the specified
   * values
   */
  'in': (number | string)[];
  /**
   * NotIn specifies that this field cannot be equal to one of the specified
   * values
   */
  'not_in': (number | string)[];
}
