import { reflushStyleNodes, getStyleNode, RULE_TYPE, KEYFRAME_TYPE, FONT_TYPE, STATIC_TYPE } from 'fela-utils';

var sheetMap = {
  fontFaces: FONT_TYPE,
  statics: STATIC_TYPE,
  keyframes: KEYFRAME_TYPE,
  rules: RULE_TYPE
};

function initNode(styleNodes, baseNode, css, type) {
  var media = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';

  var node = getStyleNode(styleNodes, baseNode, type, media);
  // in case that there is a node coming from server already
  // but rules are not matchnig
  if (node.textContent !== css) {
    node.textContent = css;
  }
}

export default function initStyleNodes(renderer) {
  renderer.styleNodes = reflushStyleNodes();
  var baseNode = renderer.styleNodes[RULE_TYPE];

  for (var style in sheetMap) {
    if (renderer[style].length > 0) {
      initNode(renderer.styleNodes, baseNode, renderer[style], sheetMap[style]);
    }
  }

  for (var media in renderer.mediaRules) {
    var mediaCSS = renderer.mediaRules[media];

    if (mediaCSS.length > 0) {
      initNode(renderer.styleNodes, baseNode, mediaCSS, RULE_TYPE, media);
    }
  }
}