'use strict';

exports.__esModule = true;

exports.default = function (path, t) {
  var cssPath = void 0;
  var classNamesPath = void 0;

  path.get('attributes').forEach(function (openElPath) {
    if (t.isJSXSpreadAttribute(openElPath.node)) {
      return;
    }

    var attrPath = openElPath.get('name');
    var name = attrPath.node.name;

    if (name === 'css') {
      cssPath = attrPath;
    }

    if (name === 'className') {
      classNamesPath = attrPath;
    }
  });

  if (!cssPath) return;

  var cssPropValue = cssPath.container && cssPath.container.value;
  var classNamesValue = classNamesPath && classNamesPath.container && classNamesPath.container.value;

  if (t.isJSXExpressionContainer(cssPropValue)) {
    cssPropValue = cssPropValue.expression;
  }

  var cssTemplateExpression = void 0;
  if (t.isTemplateLiteral(cssPropValue)) {
    cssTemplateExpression = createCssTemplateExpression(cssPropValue);
  } else if (t.isStringLiteral(cssPropValue)) {
    cssTemplateExpression = createCssTemplateExpression(t.templateLiteral([t.templateElement({
      raw: cssPropValue.value,
      cooked: cssPropValue.value
    })], []));
  } else {
    throw path.buildCodeFrameError(cssPropValue.value + ' is not a string or template literal');
  }

  if (!classNamesValue) {
    cssPath.parentPath.replaceWith(createClassNameAttr(cssTemplateExpression));
    return;
  }

  cssPath.parentPath.remove();
  if (t.isJSXExpressionContainer(classNamesValue)) {
    classNamesPath.parentPath.replaceWith(createClassNameAttr(add(add(classNamesValue.expression, t.stringLiteral(' ')), cssTemplateExpression)));
  } else {
    classNamesPath.parentPath.replaceWith(createClassNameAttr(add(add(t.stringLiteral(classNamesValue.value || ''), t.stringLiteral(' ')), cssTemplateExpression)));
  }

  function add(a, b) {
    return t.binaryExpression('+', a, b);
  }

  function createClassNameAttr(expression) {
    return t.jSXAttribute(t.jSXIdentifier('className'), t.JSXExpressionContainer(expression));
  }

  function createCssTemplateExpression(templateLiteral) {
    return t.taggedTemplateExpression(t.identifier('css'), templateLiteral);
  }
};