/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { FirebaseApp } from '@firebase/app-types';
import { Location } from './implementation/location';
import { Request } from './implementation/request';
import { RequestInfo } from './implementation/requestinfo';
import { XhrIoPool } from './implementation/xhriopool';
import { Reference } from './reference';
import { Provider } from '@firebase/component';
import { FirebaseAuthInternalName } from '@firebase/auth-interop-types';
/**
 * A service that provides firebaseStorage.Reference instances.
 * @param opt_url gs:// url to a custom Storage Bucket
 *
 * @struct
 */
export declare class StorageService {
    private app_;
    private readonly bucket_;
    private readonly internals_;
    private readonly authProvider_;
    private readonly appId_;
    private readonly pool_;
    private readonly requests_;
    private deleted_;
    private maxOperationRetryTime_;
    private maxUploadRetryTime_;
    constructor(app: FirebaseApp | null, authProvider: Provider<FirebaseAuthInternalName>, pool: XhrIoPool, url?: string);
    private static extractBucket_;
    getAuthToken(): Promise<string | null>;
    /**
     * Stop running requests and prevent more from being created.
     */
    deleteApp(): void;
    /**
     * Returns a new firebaseStorage.Reference object referencing this StorageService
     * at the given Location.
     * @param loc The Location.
     * @return A firebaseStorage.Reference.
     */
    makeStorageReference(loc: Location): Reference;
    makeRequest<T>(requestInfo: RequestInfo<T>, authToken: string | null): Request<T>;
    /**
     * Returns a firebaseStorage.Reference for the given path in the default
     * bucket.
     */
    ref(path?: string): Reference;
    /**
     * Returns a firebaseStorage.Reference object for the given absolute URL,
     * which must be a gs:// or http[s]:// URL.
     */
    refFromURL(url: string): Reference;
    get maxUploadRetryTime(): number;
    setMaxUploadRetryTime(time: number): void;
    get maxOperationRetryTime(): number;
    setMaxOperationRetryTime(time: number): void;
    get app(): FirebaseApp | null;
    get INTERNAL(): ServiceInternals;
}
/**
 * @struct
 */
export declare class ServiceInternals {
    service_: StorageService;
    constructor(service: StorageService);
    /**
     * Called when the associated app is deleted.
     */
    delete(): Promise<void>;
}
