import { RULE_TYPE, KEYFRAME_TYPE, FONT_TYPE, STATIC_TYPE } from 'fela-utils';

var sheetMap = {
  fontFaces: FONT_TYPE,
  statics: STATIC_TYPE,
  keyframes: KEYFRAME_TYPE,
  rules: RULE_TYPE
};


export default function renderToSheetList(renderer) {
  var sheetList = [];

  for (var style in sheetMap) {
    if (renderer[style].length > 0) {
      sheetList.push({
        css: renderer[style],
        type: sheetMap[style]
      });
    }
  }

  for (var _media in renderer.mediaRules) {
    var mediaCSS = renderer.mediaRules[_media];

    if (mediaCSS.length > 0) {
      sheetList.push({
        css: mediaCSS,
        type: RULE_TYPE,
        media: _media
      });
    }
  }

  return sheetList;
}