import { createStyleTagMarkup, RULE_TYPE, KEYFRAME_TYPE, FONT_TYPE, STATIC_TYPE } from 'fela-utils';

var sheetMap = {
  fontFaces: FONT_TYPE,
  statics: STATIC_TYPE,
  keyframes: KEYFRAME_TYPE,
  rules: RULE_TYPE
};

export default function renderToMarkup(renderer) {
  var markup = '';

  for (var style in sheetMap) {
    if (renderer[style].length > 0) {
      markup += createStyleTagMarkup(renderer[style], sheetMap[style]);
    }
  }

  for (var media in renderer.mediaRules) {
    var mediaCSS = renderer.mediaRules[media];

    if (mediaCSS.length > 0) {
      markup += createStyleTagMarkup(mediaCSS, RULE_TYPE, media);
    }
  }

  return markup;
}