'use strict';

exports.__esModule = true;
exports.getIdentifierName = getIdentifierName;
exports.getRuntimeImportPath = getRuntimeImportPath;
exports.buildMacroRuntimeNode = buildMacroRuntimeNode;
exports.addRuntimeImports = addRuntimeImports;

var _utils = require('./utils');

function getIdentifierName(path, t) {
  var parent = path.findParent(function (p) {
    return p.isVariableDeclarator();
  });
  return parent && t.isIdentifier(parent.node.id) ? parent.node.id.name : '';
}

function getRuntimeImportPath(path, t) {
  var binding = path.scope.getBinding(path.node.name);
  if (!t.isImportDeclaration(binding.path.parentPath)) {
    throw binding.path.buildCodeFrameError('the emotion macro must be imported with es modules');
  }
  var importPath = binding.path.parentPath.node.source.value;
  return importPath.match(/(.*)\/macro/)[1];
}

function buildMacroRuntimeNode(path, state, importName, t) {
  var runtimeImportPath = getRuntimeImportPath(path, t);
  if (state.emotionImports === undefined) state.emotionImports = {};
  if (state.emotionImports[runtimeImportPath] === undefined) {
    state.emotionImports[runtimeImportPath] = {};
  }
  if (state.emotionImports[runtimeImportPath][importName] === undefined) {
    state.emotionImports[runtimeImportPath][importName] = path.scope.generateUidIdentifier(path.node.name);
  }
  return state.emotionImports[runtimeImportPath][importName];
}

function addRuntimeImports(state, t) {
  if (state.emotionImports === undefined) return;
  (0, _utils.forEach)((0, _utils.keys)(state.emotionImports), function (importPath) {
    var importSpecifiers = [];
    (0, _utils.forEach)((0, _utils.keys)(state.emotionImports[importPath]), function (importName) {
      var identifier = state.emotionImports[importPath][importName];
      if (importName === 'default') {
        importSpecifiers.push(t.importDefaultSpecifier(identifier));
      } else {
        importSpecifiers.push(t.importSpecifier(identifier, t.identifier(importName)));
      }
    });
    state.file.path.node.body.unshift(t.importDeclaration(importSpecifiers, t.stringLiteral(importPath)));
  });
  state.emotionImports = undefined;
}